/*
   event.c - This is Foundation (and so, another journey begins!)

   Marc Wolfgram, 25Jan91
   ----------------------------------------------------------------
 */
#pragma noroot
#pragma keep "o/event"

#include "Shell.h"
#include <foundation.h>
#include <qdaux.h>
#include <desk.h>
#include <list.H>
#include <lineedit.h>
#include <stdio.h>
#include <stdfile.h>
#include <usrlib.h>
#include <ctype.h>
#include <locator.h>
#include <print.h>
#include <scrap.h>

void            activateEvent(void);
void            checkClipboard(void);
word            closeRoot(word, word);
void            closeDucks(void);
void            ctrlEvent(void);
void            drawItemText(char *, word);
void            generalEvent(word);
void            goAwayEvent(GrafPortPtr);
void            listDispatcher(word, word, long);
void            main(void);
void            menuEvent(long, word);
word 			Printer(word);
void            swapVidMode(void);
void            showClipboard(void);

void            CalcClipBounds(void);

extern word         workIndex;
extern workFileRec  workList[];  /* work file array [0..3] */
extern word         fMenuGlobal, AddMenuID, callFileID;
extern char         tempName[], nameText[];  /* from names.c */
extern void         DrawProc(), NullProc(), ItemProc();
extern MenuTemplate **selectorMenuH;
extern long 		**selectorItemH, callVector;
extern master       MasterRace[];
extern Rect         ItemTextRect;
extern NameRecGS    KillPB;

word fResID, pResID, qFlag, vMode, c320, wClass, fScrapCnt, CurMurphy,
     nameState, moonIndex, clipFileID, InsetToMenu5;
long masterTaskMask, orTaskMask, andTaskMask, workTaskMask, *strings,
     moonTick, moonPhase[8];
char *AlertArray[10];
GrafPortPtr     SysWPtr, CurWinP, helpWin1, helpWin2, nameTargetWinP;
MenuBarRecHndl  SysMHndl;
remFileLinkPtr  linkREM;
remTypeLinkPtr  rootREM, rootSEM, CurREM;
fWindowRec      CurWindow;
WindColorPtr    SysWColor, WColors[8];
EventRecord     fTaskRec, miscTaskRec;
prefDataHndl    prefDataH;

VersionRecGS    versionPB = { 1, 0 };
QuitRecGS       quitPB = { 0, 0L, 0 };

fActivateRec    fActivatePB;    /* call parameter blocks */
fCloseRec       fClosePB;
fEventRec       fEventPB;
fOpenRec        fOpenPB;
fCloseRec       fPrintPB;
fCloseRec       fWritePB;
fVidModeRec     fVidModePB;

fResLinkRec     fBuildLinkPB;   /* callback parameter blocks */
fResNameRec     fGetWTitlePB, namePB;

word fEventMagic[] =   { 0x0000, 0x1000, 0x0800, 0x4820, 0x4840, 0x4860, 0x4820, 0x4840  };

/*--------------------------------------
    main is the Foundation event loop

    Marc Wolfgram,  8/ 9/91 17:50:10
*/
void main(void)
{
word            i, err, temp, task, menu4;
long			hdiResult;
fWindowRecHndl  refH;
GrafPortPtr     winP;
Handle          tHand;

    GetVersion(&versionPB);
    if ((versionPB.version &0x07ff) < 0x0400) {
		InitCursor();
        temp = AlertWindow(0x0034, 0L, Version_Alert);
        return;
    }

    temp = (versionPB.version & 0x8000) ? -1 : 0;

    qFlag = FALSE;
    vMode = 1;
    c320 = 0;
    clipFileID = 0;

    workTaskMask = masterTaskMask   = 0x001f7fffL;
    orTaskMask                      = 0x00002186L;
    andTaskMask                     = 0x001fffffL;

    SysWPtr = GetWMgrPort();
    SetPort(SysWPtr);

    fResID = GetCurResourceFile();

	moonIndex = 0;
	moonTick = 0L;
	for (i = 0; i < 8; i++)
    	moonPhase[i] = (long) deref(LoadResource(rCursor, (long) i + 1L));

    winP = openAboutWin(temp);

	helpWin1 = 0L;
    helpWin2 = 0L;
    selectorMenuH = 0L;
    selectorItemH = 0L;

    MoonCursor();
    SysMHndl = NewMenuBar2(2, fMenuBar, 0L);
    MoonCursor();
    SetSysBar(SysMHndl);
    SetMenuBar(0L);
    MoonCursor();
    FixAppleMenu((word) AppleMenu);
    MoonCursor();
    FixMenuBar();
    SetMenuFlag(0x0080, 4);
    DrawMenuBar();
    MoonCursor();
    CalcClipBounds();
    getPrefs();
    remInit();
    stringInit();
    buildAddMenu();

    fScrapCnt = GetScrapCount();

    for (i = 0; i < 8; i++)
        WColors[i] = (WindColorPtr) deref(LoadResource(rWindColor, (long) i + 1L));
    SysWColor = (WindColorPtr) deref(LoadResource(rWindColor, 0x7ff0001L));

    for (i = 0; i < 4; i++)
        CheckMItem(0, (word) EditFile1Item + i);

    fMenuGlobal = 0x8140; /* New Open About Other Help Preferences */

    CloseWindow(winP);

    openDefault();

    InitCursor();

    wClass = 0;     /* startup default is no window open */
    menu4 = 0;

    do {
        fTaskRec.wmTaskMask = workTaskMask;
        fTaskRec.wmTaskMask |= orTaskMask;
        fTaskRec.wmTaskMask &= andTaskMask;

        task = TaskMaster(everyEvent , &fTaskRec ) ;

        updateHelp2(task);

        switch (task) {

        case inNull:
            if (fTaskRec.what) /* disable the twilight zone */
				continue;

            hdiResult = HandleDiskInsert(0xc000, 0);

			winP = FrontWindow();
            if (winP) {
				if (GetSysWFlag(winP)) {    /* if its an NDA then... */
                    if (!menu4) {
                        menu4 = GetMenuFlag(4);
                        SetMenuFlag(0x0080, 4);
                        HiliteMenu(0, 4);
					    SetupMenu(0x8c27 | (fMenuGlobal & 0x0040));
                        if (helpWin1) {
                            refH = (fWindowRecHndl) GetWRefCon(helpWin1);
                            if ((**refH).remSignature == 1) {
                                (**refH).resID = 93L;
                                (**refH).resFileID = fResID;
                                updateHelp1(refH);
                            }
                        }
                    }
                }
				else {
                    if (menu4) {           /* otherwise... */
                        SetMenuFlag(menu4, 4);
                        HiliteMenu(0, 4);
                        menu4 = 0;
                    }
                    SetupMenu(0x4020);
                }
            }
            else
				SetupMenu(0x0c20);

        case mouseDownEvt:
        case mouseUpEvt:
        case keyDownEvt:
        case autoKeyEvt:
        case updateEvt:
        case wInDesk:
        case wClickCalled:
        case wInContent:
        case wInDrag:
        case wInGrow:
        case wInZoom:
        case wInInfo:
        case wInFrame:
        case wTrackZoom:
        case wHitFrame:
            generalEvent(task);
            break;

        case activateEvt:
            wClass = winSetup((GrafPortPtr) fTaskRec.wmTaskData);
            activateEvent();
            break;

        case wInMenuBar:
        case wInSpecial:
            menuEvent(fTaskRec.wmTaskData, task);
            break;

        case wInGoAway:
            goAwayEvent((GrafPortPtr) fTaskRec.wmTaskData);
            break;

        case wInControl:
            ctrlEvent();
            break;
        }

        checkListStatus();
        checkClipboard();

    } while (!qFlag);  /* Keep going until qFlag is set */

    disposeTypeLink(rootREM);
    disposeTypeLink(rootSEM);
    disposeFileLink(linkREM);
    winP = findSignature(0x48e5, 0, 0, 0L);
    if (winP) {
        DisposeHandle((Handle) GetWRefCon(winP));
        CloseWindow(winP);
    }
    if (fScrapCnt != GetScrapCount() || GetScrapState()) {
         winP = NoteWindow((char *) strings[39]);
         UnloadScrap();
         CloseWindow(winP);
    }

    KillPB.pCount = 1;
    KillPB.pathname = &workFile;
    for (i = 0; i < 4; i++) {
        workFile_s = (char) i + 'a';
        DestroyGS(&KillPB);
    }

    DisposeHandle(FindHandle((Pointer) strings));
} /* main */

/*======================================
 *  the event handlers
 *--------------------------------------
    generalEvent handles all non-specific event routing

    Marc Wolfgram
*/
void generalEvent(word task)
{
word            listItem, type, ID;
fListCtlRecHndl ctlH;
fWindowRecHndl  refH;
fMemberHndl     memH;
fMemberPtr      memP;
resLinkRecHndl  linkH;
resLink        *linkP;

    switch (wClass) {
    case 0:     /* no window open */
    case -1:    /* not Foundation */
        break;

    case REM_nselector:
    case REM_native:
    case REM_script:
    case REM_hexascii:
        fEventPB.resType = CurWindow.resType;
        fEventPB.resID = CurWindow.resID;
        fEventPB.fFlag = CurMurphy;

        if (wClass == REM_nselector) {
            fEventPB.fFlag |= 0x0400;   /* set selector bit */
            fEventPB.fFlag &= 0xff7f;   /* clear menu bit */
        }
        else
            fEventPB.fFlag &= 0xfb7f;   /* clear selector and menu bits */
        fEventPB.taskCode = task;
        callREM(_EVENT, (Pointer) &fEventPB);
        break;

    case REM_fileroot:
    case REM_tselector:
        if (task == keyDownEvt) {
            if ((fTaskRec.message & 0xffL) == 0x0d) {
                ctlH = (fListCtlRecHndl) GetCtlHandleFromID(CurWinP, 2L);
                listItem = NextMember2(0, (Handle) ctlH);
                if (listItem) {
                    refH = (fWindowRecHndl) GetWRefCon(CurWinP);
                    memH = (**ctlH).ctlListRef;
                    memP = (fMemberPtr) deref((Handle) memH);
                    listDispatcher((**refH).remSignature, (**refH).resType, memP[listItem-1].nref);
                }
            }
        }
        break;

    case REM_dselector:
        if (task == keyDownEvt) {
            if ((fTaskRec.message & 0xffL) == 0x0d) {
                refH = (fWindowRecHndl) GetWRefCon(CurWinP);
                linkH = (resLinkRecHndl) (**refH).resPrivate;
                linkP = &(**linkH).ref[(**refH).resType];
                switch((**refH).resID & 0xffffL) {
                case 2L:
                case 4L:
                    listDispatcher((**refH).remSignature, linkP->resType, linkP->resID);
                    break;

                case 3L:
                    listDispatcher((**refH).remSignature, linkP->hostType, linkP->hostID);
                    break;
                }
            }
        }
        break;

    default:
        break;

    }
}

/*--------------------------------------
    activateEvent handles the necessary magic specific to you guessed it...

    locals consume 4 bytes of stack space

    Marc Wolfgram
*/
void activateEvent(void)
{
word i, setCloseFile, helpFileID;
long helpResID, *ID;
fWindowRecHndl  refH;

    workTaskMask = masterTaskMask;

    setCloseFile = 0;
    helpResID = 0L;
    helpFileID = fResID;

    switch (wClass) {
    case REM_nselector:
    case REM_native:
    case REM_script:
    case REM_hexascii:
        fActivatePB.resType = CurWindow.resType;
        fActivatePB.resID = CurWindow.resID;
        fActivatePB.fFlag = CurMurphy;

        if (wClass == REM_nselector) {
            nameTargetWinP = 0L;
            fActivatePB.fFlag |= 0x0400;    /* set selector and activate bits */
            fActivatePB.fFlag &= 0xff7f;    /* clear menu bit */
        }
        else
            fActivatePB.fFlag &= 0xfb7f;    /* clear selector and menu bits */

        if (fTaskRec.modifiers & 0x0001) { /* activate */
            setCloseFile++;
            if (wClass == REM_nselector) {  /* getlink - exclude HexREM too */
                fBuildLinkPB.pCount = 8;
                fBuildLinkPB.hostType = CurWindow.resType;
                fBuildLinkPB.hostID = CurWindow.resID;
                fBuildLinkPB.resFileID = CurWindow.resFileID;
                remBuildLinkHand((fResLinkRecPtr) &fBuildLinkPB);
                fActivatePB.linkHand = fBuildLinkPB.linkHand;
            }
            else
                fActivatePB.linkHand = 0L;

            fActivatePB.fFlag |= 0x8000;    /* set activate bit */
            if (wClass != REM_nselector) {
            	insertMenu5(CurREM->menuHndl);
                nameTargetWinP = (GrafPortPtr) fTaskRec.wmTaskData;
            }
            callREM(_ACTIVATE, (Pointer) &fActivatePB);
            workTaskMask = CurWindow.remTaskMask;

            ID = (long *) callVector + 8;
            if (*ID) {
                helpResID = *ID;
                helpFileID = callFileID;
            }
            else
                helpResID = 94L;
        }
        else {                              /* deactivate */
            fActivatePB.fFlag &= 0x7fff;    /* clear activate bit */
            fActivatePB.linkHand = 0L;
            callREM(_ACTIVATE, (Pointer) &fActivatePB);
            removeMenu5();
        	SetupMenu(0x041f);
        }
        break;

    case REM_fileroot:
        nameTargetWinP = 0L;
        if (fTaskRec.modifiers & 0x0001) {    /* activate */
            setCloseFile++;
            removeMenu5();
            workTaskMask = CurWindow.remTaskMask;
            helpResID = GetScrapSize(0x8003);
            if (!toolerror())
                SetupMenu(0x4800);
            SetupMenu(0x041f);
            helpResID = 100L;
        }
        else
        	SetupMenu(0x0800);
        break;

    case REM_tselector:
        if (fTaskRec.modifiers & 0x0001) {    /* activate */
        	nameTargetWinP = (GrafPortPtr) fTaskRec.wmTaskData;
            setCloseFile++;
            removeMenu5();
            workTaskMask = CurWindow.remTaskMask;
            helpResID = GetScrapSize(0x8003);
            if (!toolerror())
                SetupMenu(0x4c00);
            else
                SetupMenu(0x4400);
            SetupMenu(0x001f);
            helpResID = 101L;
        }
        else
        	SetupMenu(0x0c00);
        break;

    case REM_dselector:
        if (fTaskRec.modifiers & 0x0001) {    /* activate */
        	nameTargetWinP = (GrafPortPtr) fTaskRec.wmTaskData;
            helpResID = 102L;
            setCloseFile++;
            removeMenu5();
            workTaskMask = CurWindow.remTaskMask;
            SetupMenu(0x001f);
        }
        break;

    case 0xe8:  /* namer */
        if (fTaskRec.modifiers & 0x0001) {    /* activate */
            helpResID = 103L;
            nameState = 0x00ff;
            drawNamer(nameTargetWinP);
            removeMenu5();
            workTaskMask = CurWindow.remTaskMask;
        }
        else
            nameTargetWinP = 0L;
        break;

    default: /* and other windows */
        nameTargetWinP = 0L;
        if (fTaskRec.modifiers & 0x0001) {    /* activate */
            removeMenu5();
            workTaskMask = CurWindow.remTaskMask;
        }
        break;
    }
    if (setCloseFile) {
        SetMItemName(&workList[workIndex].fileName[0], (word) CloseFileItem);
        SetMItemName(&workList[workIndex].packName[0], (word) OptimizeItem);
        SetupMenu(0x4200);
        CalcMenuSize(0,0,2);
        CheckMItem(-1, (word) EditFile1Item + workIndex);
        for (i = 0; i < 4; i++)
            if (i != workIndex)
                CheckMItem(0, (word) EditFile1Item + i);
    }
    drawNamer(nameTargetWinP);

    if ((fTaskRec.modifiers & 0x0001) && helpWin1 && helpResID) {
        refH = (fWindowRecHndl) GetWRefCon(helpWin1);
        if ((**refH).remSignature == 1) {
            (**refH).resID = helpResID;
            (**refH).resFileID = helpFileID;
            updateHelp1(refH);
        }
    }
}

/*--------------------------------------
    menuEvent handles routing to menu item hits...

    locals consume 12 bytes of stack space

    Marc Wolfgram,  8/ 9/91 20:53:14
*/
void menuEvent(long menuID, word task)
{
word i, temp, skip, hitItem, hitMenu;
remTypeLinkPtr  typeLink;
GrafPortPtr winP;

    asm {
        lda menuID
        sta hitItem
        lda menuID+2
        sta hitMenu
    }

    switch (hitItem) {

    case CopyItem:
        if (wClass == REM_tselector) {
        	itemCopy();
			break;
     	}

    case PasteItem:
        if (wClass == REM_tselector || wClass == REM_fileroot) {
        	itemPaste();
			break;
     	}

    case UndoItem:
    case CutItem:
    case ClearItem:
        generalEvent(task);
        break;

    case CloseItem:
        goAwayEvent(FrontWindow());
        break;

    case SelectAllItem:
        generalEvent(task);
        break;

    case QuitItem:
        temp = skip = 0;

        for (i = 0; i < 4; i++) {   /* handle the dirty work first */
            if (workList[i].wFlag & 0x4000) {
                temp = closeRoot(i, 1);
                if (temp) {
                    skip++;
                    break;
                }
            }
        }
        if (skip)
            break;

        for (i = 0; i < 4; i++)     /* then kill any stragglers... */
            if (workList[i].wFlag & 0x1000)
                closeRoot(i, 1);

        closeDucks();

        qFlag = TRUE;
        break;

    case NewItem:
        NewFile();
        break;

    case OpenItem:
        OpenFile((prefDataHndl) 0L);
        break;

    case SaveItem:
        SaveFile(workIndex, workList[workIndex].wFlag & 0x2000);
        break;

    case SaveAsItem:
        SaveFile(workIndex, -1);
        break;

    case PageSetupItem:
    	Printer(1);
        break;

    case PrintItem:
        Printer(0);
        break;

    case AboutItem:
        switch (wClass) {
        case -1:    /* not Foundation */
            temp = 0;
            break;

        case REM_nselector: /* one of the REMs */
        case REM_native:
        case REM_script:
        case REM_hexascii:
            temp = CurREM->link->resFileID;
            break;

        default: /* the shell */
            temp = fResID;
            break;
        }
        if (temp)
            CloseWindow(openAboutWin(temp));
        break;

    case ShowClipboardItem:
        showClipboard();
        break;

    case SwitchModeItem:
        swapVidMode();
        break;

    case PreferencesItem:
        prefDataH = editPrefs(prefDataH);
        break;

    case ImportDataItem:
        importRequested();
        break;

    case UserResourceItem:
        fOpenPB.resType = 0;
        fOpenPB.resID = 0L;
        fOpenPB.fFlag = 0x1800; /* hexedit & script bits set */
        fOpenPB.Data = 0L;
        fOpenPB.wColorPtr = (Pointer) WColors[workIndex];
        callREM(_OPEN, (Pointer) &fOpenPB);
        break;

    case HelpItem:
		openHelpWin();
        break;

    case CloseFileItem:
        closeRoot(workIndex, 0);
        break;

    case EditFile1Item:
    case EditFile2Item:
    case EditFile3Item:
    case EditFile4Item:
        SelectWindow(workList[hitItem-EditFile1Item].rootWinP);
        break;

    case OptimizeItem:
        OptimizeFile();
        break;

    case NameResItem:
        openNamer();
        break;

    case MakeRefItem:
        MakeReferenceFile();
        break;

    default:
        if (hitItem > 0x2ef) {  /* rem menu hit - including selector stuff */
            generalEvent(task);
            break;
        }
        if (hitItem > 0x1ff) {  /* add type hit */
            typeLink = getMenuLinkRef(hitItem);
            fOpenPB.resType = typeLink->resType;
            fOpenPB.resID = 0L;
            fOpenPB.fFlag = typeLink->rFlag & 0x1000;
            fOpenPB.Data = 0L;
            fOpenPB.wColorPtr = (Pointer) WColors[workIndex + c320];
            callREM(_OPEN, (Pointer) &fOpenPB);
            break;
        }
        temp = AlertWindow(0x0034, 0L, Construction_Alert);
        break;
    }
    HiliteMenu(0, hitMenu) ; /* Un-hilite menu title */

} /* doMenuHit */

char titleBuf[128];

/*--------------------------------------
    ctrlEvent handles hits in controls

    Marc Wolfgram,  8/ 9/91 22:26:12
*/
void ctrlEvent(void)
{
word            listItem, hostType, dispatch;
long            dItemCtl, linkItem;
fWindowRecHndl  refH, nameTargetRefH;
fWindowRecPtr   refP;
GrafPortPtr     winP, oldP, itmP;
fListCtlRecHndl ctlH;
fMemberHndl     memH;
fMemberPtr      memP;
resLinkRecHndl  linkH;
resLink        *linkP;
nameSubPtr      nameSubP;

    oldP = GetPort();

    ctlH = (fListCtlRecHndl) fTaskRec.wmTaskData2;  /* we know the ancestry */
    winP = (GrafPortPtr) (**ctlH).ctlOwner;
    SetPort(winP);
    refH = (fWindowRecHndl) GetWRefCon(winP);
    refP = (fWindowRecPtr) deref((handle) refH);

    switch (wClass) {
    case REM_nselector:
    case REM_native:
    case REM_script:
    case REM_hexascii:
        fEventPB.resType = CurWindow.resType;
        fEventPB.resID = CurWindow.resID;
        fEventPB.fFlag = CurMurphy;

        if (wClass == REM_nselector) {
            fEventPB.fFlag |= 0x0400;   /* set selector bit */
            fEventPB.fFlag &= 0xff7f;   /* clear menu bit */
        }
        else
            fEventPB.fFlag &= 0xfb7f;   /* clear selector and menu bits */
        fEventPB.taskCode = wInControl;
        callREM(_EVENT, (Pointer) &fEventPB);
        break;

    case REM_fileroot:
    case REM_tselector:
        if (fTaskRec.wmTaskData4 == 1L) { /* popup - set action, then go on */
            refP->remSignature = GetCtlValue((CtlRecHndl) fTaskRec.wmTaskData2);
			if ((**prefDataH).pFlag & 0x4000)
				return;
		}
        else if (fTaskRec.wmTaskData4 == 2L) {  /* list - do we dispatch? */
            if (fTaskRec.wmClickCount != 2) {   /* no, not a double click */
    			if (wClass == REM_tselector) {   /* update the info & names */
                    drawFooter(wClass, winP, refP);
                    drawNamer(nameTargetWinP);
                }
                break;
         	}
        }
        else            /* all other shit - list scroll parts for example */
            break;

        ctlH = (fListCtlRecHndl) GetCtlHandleFromID(CurWinP, 2L);
        listItem = NextMember2(0, (Handle) ctlH);
        if (listItem) {
            memH = (**ctlH).ctlListRef;
            memP = (fMemberPtr) deref((Handle) memH);
            listDispatcher(refP->remSignature, refP->resType, memP[listItem-1].nref);
        }
        break;

    case REM_dselector:
        dispatch = 1;
        linkH = (resLinkRecHndl) refP->resPrivate;
        linkP = (**linkH).ref;
        hostType = linkP[(word) linkP[0].hostHitTick].hostType;

        ctlH = (fListCtlRecHndl) GetCtlHandleFromID(winP, 2L);

        dItemCtl = linkP[0].hostID;
        linkItem = linkP[0].resHitTick;

        if (fTaskRec.wmTaskData4 == 1L) { /* popup - set action, then go on */
            refP->remSignature = GetCtlValue((CtlRecHndl) fTaskRec.wmTaskData2);
			if ((**prefDataH).pFlag & 0x4000)
				dispatch = 0;
        }
        else {
            if (fTaskRec.wmTaskData4 == 2L) { /* list ctl */
                listItem = NextMember2(0, (Handle) ctlH);
                memH = (**ctlH).ctlListRef;
                memP = (fMemberPtr) deref((Handle) memH);
                if (!listItem)
                    break;
                if (dItemCtl == 3L || dItemCtl == 4L)
                    hiliteRect(GetCtlHandleFromID(winP, (long) dItemCtl));
                linkItem = memP[listItem-1].nref;
            }
            else {
                if (fTaskRec.wmTaskData4 == 3L) {  /* parent - do we dispatch? */
                    if (!hostType)
                        break;
                    if (dItemCtl == 4L)
                        hiliteRect(GetCtlHandleFromID(winP, 4L));
                }
                else if (fTaskRec.wmTaskData4 == 4L) {  /* item - do we dispatch? */
                    if (dItemCtl == 3L)
                        hiliteRect(GetCtlHandleFromID(winP, 3L));
                }
                else
                    break;

                if (dItemCtl == 2L)
                    DrawMember2(ResetMember2((Handle) ctlH), (Handle) ctlH);

                if (dItemCtl != fTaskRec.wmTaskData4)
                    hiliteRect(GetCtlHandleFromID(winP, fTaskRec.wmTaskData4));

                linkItem = linkP[0].hostHitTick;
            }
            linkP[0].hostID = dItemCtl = fTaskRec.wmTaskData4;
            linkP[0].resHitTick = linkItem;

            if (fTaskRec.wmClickCount != 2)
                dispatch = 0;
        }

        if (dItemCtl == 3L) {
            refP->resType = linkP[linkItem].hostType;
            refP->resID = linkP[linkItem].hostID;
        }
        else {
            refP->resType = linkP[linkItem].resType;
            refP->resID = linkP[linkItem].resID;
        }

        refP->remSignature = setupItemMenu(refP->remSignature, refP->resType, winP);

        nameSubP = getNameSubRec(workIndex, refP->resType, refP->resID);
        drawItemText(nameSubP ? nameSubP->name : (char *) strings[67], 112);
		drawNamer(nameTargetWinP);

        if (dispatch)
            listDispatcher(refP->remSignature, refP->resType, refP->resID);
        break;

    case 0x00e4:
        if (fTaskRec.wmTaskData4 == 2L) {  /* help popup */
            refP->remSignature = GetCtlValue(GetCtlHandleFromID(helpWin1, 2L));
            refP->resID = (long) refP->remSignature;
            refP->resFileID = fResID;
            updateHelp1(refH);
        }
        break;

    case 0x00e8:        /* namer */
        if (fTaskRec.wmTaskData4 == 1L) { /* namer apply */
            GetLETextByID(winP, 2L, (StringPtr) nameText);
            nameTargetRefH = (fWindowRecHndl) GetWRefCon(nameTargetWinP);
            namePB.pCount = 3;
            namePB.resType = (**nameTargetRefH).resType;
            namePB.resID = (**nameTargetRefH).resID;
            if (!namePB.resID) {
        		ctlH = (fListCtlRecHndl) GetCtlHandleFromID(nameTargetWinP, 2L);
        		listItem = NextMember2(0, (Handle) ctlH);
                if (listItem) {
                	memH = (**ctlH).ctlListRef;
        			memP = (fMemberPtr) deref((Handle) memH);
            		namePB.resID = memP[listItem-1].nref;
        		}
            }
            namePB.resName = nameText;
            remSetResourceName(&namePB);
            nameState = 0x00ff;

            itmP = findSignature(REM_signature + REM_dselector + workIndex, 0, namePB.resType, namePB.resID);
            if (itmP) {
                SetPort(itmP);
                InvalRect(&ItemTextRect);
            }
        }
        else if (nameState == 0x00ff && fTaskRec.wmTaskData4 == 2L)
            nameState = 0x0000; /* LE hit, so apply is now valid */

        HiliteControl(nameState, GetCtlHandleFromID(winP, 1L));
        break;

    default: /* no window or not Foundation's */
        break;
    }
    if (refH)
        HUnlock((Handle) refH);
    SetPort(oldP);

}

/*--------------------------------------
    goAwayEvent does away with what's ours

    locals consume 8 bytes of stack space

    Marc Wolfgram,  8/ 9/91 22:27:48
*/
void goAwayEvent(GrafPortPtr winP)
{
fListCtlRecHndl listCtlH;
fWindowRecHndl  refH;

    wClass = winSetup(winP);

  	switch (wClass) {
    case 0:     /* no window open */
        break;

    case REM_nselector:
    	if (fTaskRec.modifiers & optionKey)
	    	closeREM(workIndex, CurWindow.resType);
		else {
        	fClosePB.resType = CurWindow.resType;
        	fClosePB.resID = CurWindow.resID;
        	fClosePB.windowPtr = (Pointer) winP;
        	fClosePB.fFlag |= 0x0400;   /* set selector bit */
        	fClosePB.fFlag &= 0xff7f;   /* clear menu bit */
        	callREM(_CLOSE, (Pointer) &fClosePB);
        }
        break;

    case REM_native:
    case REM_script:
    case REM_hexascii:
        fClosePB.resType = CurWindow.resType;
        fClosePB.resID = CurWindow.resID;
        fClosePB.windowPtr = (Pointer) winP;
       	fClosePB.fFlag = CurMurphy;
        fClosePB.fFlag &= 0xfb7f;   /* clear selector and menu bits */
        if (winP == nameTargetWinP)
            nameTargetWinP = 0L;
        callREM(_CLOSE, (Pointer) &fClosePB);
        break;

    case REM_fileroot:
    	if (fTaskRec.modifiers & optionKey)
	    	closeTypes(workIndex);
		else
		  	closeRoot(workIndex, 0);
        break;

    case REM_tselector:
    	if (fTaskRec.modifiers & optionKey) {
	    	closeREM(workIndex, CurWindow.resType);
			break;
		}
    case REM_dselector:
		listCtlH = (fListCtlRecHndl) GetCtlHandleFromID(winP, 2L);
        if ((**listCtlH).ctlListRef) {
            DisposeHandle((Handle) (**listCtlH).ctlListRef);
            (**listCtlH).ctlListRef = 0L;
        }
        refH = (fWindowRecHndl) GetWRefCon(winP);
        if ((**refH).resPrivate)
            DisposeHandle((Handle) (**refH).resPrivate);
        DisposeHandle((Handle) GetWRefCon(winP));
        CloseWindow(winP);
        break;

    case 0xe4: /* help */
        refH = (fWindowRecHndl) GetWRefCon(winP);
        if ((**refH).resPrivate)
            DisposeHandle((Handle) (**refH).resPrivate);
        DisposeHandle((Handle) GetWRefCon(winP));
        CloseWindow(winP);
        helpWin1 = 0L;
        break;

    case 0xe5: /* clipboard */
	case 0xe8: /* namer */
        DisposeHandle((Handle) GetWRefCon(winP));
        CloseWindow(winP);
        break;

    case 0xef: /* help debugger */
        DisposeHandle((Handle) GetWRefCon(winP));
        CloseWindow(winP);
        helpWin2 = 0L;
        break;

    default:
        if (!GetSysWFlag(winP))
            CloseWindow(winP);
        break;
    }
}

segment "F_MISCCODE";
/*======================================
 *  menu handlers and misc functions
 *--------------------------------------
    winSetup is passed a window grafportptr and returns one of the
    following values based on the window's secrets...

           0x0000       No window open
        0x0010..00a0    REM or non-general shell window
        0x00e0..00ef    General shell window
           0xffff       Not a Foundation window (NDA)

    the CurWindow structure is filled appropriately if the window is one
    of ours.

    the workIndex variable is set if the window is associated with an open
    Foundation work file.

    Marc Wolfgram,  8/ 9/91 17:34:49
*/
word winSetup(GrafPortPtr winPtr)
{
word retVal, i;
Handle refConH;
fWindowRecPtr   refConP;

    CurWinP = 0L;
    retVal = 0;
    if (winPtr != 0L) {
    	refConH = (Handle) GetWRefCon(winPtr);
        if (!refConH)
            return -1;
        refConP = (fWindowRecPtr) deref(refConH);
        CurWindow.Signature = retVal = refConP->Signature;
        if ((retVal & 0xff00) == REM_signature) {
            CurWinP = winPtr;
			SetupMenu(fMenuGlobal);
            CurWindow.resID = refConP->resID;
            CurWindow.resType = refConP->resType;
            CurWindow.resFileID = refConP->resFileID;
            CurWindow.remTaskMask = refConP->remTaskMask;
            CurWindow.remSignature = refConP->remSignature;
            CurWindow.resPrivate = refConP->resPrivate;
            if ((retVal & 0x00f0) == REM_general)
				retVal &= 0x00ff;
            else {
                workIndex = retVal & 0x0003;

                retVal &= 0x00f0;
                switch (retVal) {
                case REM_nselector:
                case REM_native:
                    CurREM = getTypeLinkRef(refConP->resType);
                    CurMurphy = 0x0000;
                    break;

                case REM_hexascii:
                    CurREM = getTypeLinkRef(0x0000);
                    CurMurphy = 0x0800;
                    break;

                case REM_script:
                    CurREM = getTypeLinkRef(0x8000);
                    CurMurphy = 0x1000;
                    break;

                default:
                    CurREM = 0L;
                    CurMurphy = 0x0000;
                	break;
                }
        	}
		}
        else
            retVal = -1;
    }
    return retVal;
}

/*--------------------------------------
    findSignature locates an open foundation window based on its refcon

    Marc Wolfgram,  9/ 7/91  0:05:03
*/
GrafPortPtr findSignature(word signature, word mode, word type, long ID)
{
fWindowRecHndl  refH;
fWindowRecPtr   refP;
GrafPortPtr     winP, found;

    found = 0L;
    winP = GetFirstWindow();
    while(winP) {
        if (!GetSysWFlag(winP)) {
            refH = (fWindowRecHndl) GetWRefCon(winP);
            refP = (fWindowRecPtr) deref((Handle) refH);
            if (refP->Signature == signature &&
               		((refP->resType == type && (refP->resID == ID || ID == 0L)) ||
               		(type == 0 && ID == 0))) {
                HUnlock((Handle) refH);
                found = winP;
                if (mode == 1)
                    SelectWindow(winP);
                if (mode == 2)
                    ShowHide(-1, winP);
                if (mode == 3)
                    ShowHide(0, winP);
                break;
            }
            HUnlock((Handle) refH);
        }
        winP = GetNextWindow(winP);
    }
    return found;
}

/*--------------------------------------
    swapVidMode

    Marc Wolfgram,  8/ 9/91 20:42:07
*/
void swapVidMode(void)
{
word i, h, wfd, wType, qdSCB, listCnt;
long  qdWAP;
fWindowRecHndl  refH;
fWindowRecPtr   refP;
GrafPortPtr     winP;
fMemberHndl     memberH;
fListCtlRecHndl listCtlH;
remTypeLinkPtr  remP;

    qdSCB = GetMasterSCB();
    qdSCB ^= 0x80;
    vMode = (qdSCB & 0x80) ? 1 : 0;
    c320 = vMode ? 0 : 4;

    qdWAP = (long) GetWAP(0, 4);

    QDAuxShutDown();
    QDShutDown();

    QDStartUp((word) qdWAP, qdSCB, 0, fMemID);
    GrafOff();
    printf((char *) strings[28]);

    QDAuxStartUp();

    ClampMouse(0, (vMode) ? 639 : 319, 0, 199);
    HomeMouse();
    ShowCursor();

    WindNewRes();
    MenuNewRes();
    CtlNewRes();

	SetupMenu(vMode ? 0x4100 : 0x0100);
    CloseAllNDAs();

    winP = GetFirstWindow();
    while(winP) {
        refH = (fWindowRecHndl) GetWRefCon(winP);
        if (!refH) {
            winP = GetNextWindow(winP);
            continue;
        }
        refP = (fWindowRecPtr) deref((Handle) refH);

        wType = refP->Signature & 0x00ff;
        if (wType < 0x00e0) {
            wfd = wType & 0x0003;
            wType &= 0x00f0;
        }

        switch (wType) {
        case REM_nselector:
        case REM_native:
            remP = getTypeLinkRef(refP->resType);
            if (remP->rFlag & 0x0010) { /* 320 aware */
                printf((char *) strings[0], refP->resType, refP->resID, wfd+1);
                fVidModePB.resType = refP->resType;
                fVidModePB.resID = refP->resID;
                fVidModePB.fFlag = (vMode) ? 0x4000 : 0x0000;
                if (wType == REM_nselector)
                	fVidModePB.fFlag |= 0x0400;
                fVidModePB.wColorPtr = (Pointer) WColors[wfd + c320];
                fVidModePB.windowPtr = (Pointer) winP;
                callREM(_VIDMODE, (Pointer) &fVidModePB);
                break;
            }

        case REM_script:
        case REM_hexascii:
            printf((char *) strings[5 + vMode], refP->resType, refP->resID, wfd+1);
            ShowHide(vMode, winP);
            break;

        case REM_fileroot:
            printf((char *) strings[1], wfd+1);

            listCtlH = (fListCtlRecHndl) GetCtlHandleFromID(winP, 2L);
            listCnt = (**listCtlH).ctlListSize;
            memberH = (fMemberHndl) (**listCtlH).ctlListRef;
            (**listCtlH).ctlListRef = 0L;
            HideControl((CtlRecHndl) listCtlH);
            DisposeControl((CtlRecHndl) listCtlH);

            listCtlH = (fListCtlRecHndl) NewControl2(winP, 2, 0x2002L);
            (**listCtlH).ctlListSize = listCnt;
            (**listCtlH).ctlMemSize = 9;
            (**listCtlH).ctlListRef = memberH;
            (**listCtlH).ctlMoreFlags = 0x3401;
            NewList2(0L, 1, (Ref) memberH, 1, listCnt, (Handle) listCtlH);

            DrawOneCtl((CtlRecHndl) listCtlH);

            SetFrameColor(WColors[wfd + c320], winP);

            ShowWindow(winP);
            break;

        case REM_tselector:
            printf((char *) strings[3], refP->resType, wfd+1);
            refP->remSignature = setupTypeMenu(refP->resType, winP);

            listCtlH = (fListCtlRecHndl) GetCtlHandleFromID(winP, 2L);
            listCnt = (**listCtlH).ctlListSize;
            memberH = (fMemberHndl) (**listCtlH).ctlListRef;
            (**listCtlH).ctlListRef = 0L;
            HideControl((CtlRecHndl) listCtlH);
            DisposeControl((CtlRecHndl) listCtlH);

            listCtlH = (fListCtlRecHndl) NewControl2(winP, 2, 0x2004L);
            (**listCtlH).ctlListSize = listCnt;
            (**listCtlH).ctlMemSize = 9;
            (**listCtlH).ctlListRef = memberH;
            (**listCtlH).ctlMoreFlags = 0x3401;
            NewList2(0L, 1, (Ref) memberH, 1, listCnt, (Handle) listCtlH);

            DrawOneCtl((CtlRecHndl) listCtlH);

            SetFrameColor(WColors[wfd + c320], winP);

            ShowWindow(winP);
            break;

        case REM_dselector:
            printf((char *) strings[51], wfd+1);
            refP->remSignature = setupTypeMenu(refP->resType, winP);

            listCtlH = (fListCtlRecHndl) GetCtlHandleFromID(winP, 2L);
            listCnt = (**listCtlH).ctlListSize;
            memberH = (fMemberHndl) (**listCtlH).ctlListRef;
            (**listCtlH).ctlListRef = 0L;
            HideControl((CtlRecHndl) listCtlH);
            DisposeControl((CtlRecHndl) listCtlH);

            listCtlH = (fListCtlRecHndl) NewControl2(winP, 2, 0x703dL);
            (**listCtlH).ctlListSize = listCnt;
            (**listCtlH).ctlMemSize = 9;
            (**listCtlH).ctlListRef = memberH;
            (**listCtlH).ctlMoreFlags = 0x3401;
            NewList2(0L, 1, (Ref) memberH, 1, listCnt, (Handle) listCtlH);

            DrawOneCtl((CtlRecHndl) listCtlH);

            SetFrameColor(WColors[wfd + c320], winP);

            ShowWindow(winP);
            break;

        case 0x00e4:                /* help - 320 is beyond this */
            printf((char *) strings[7 + vMode]);
            ShowHide(vMode, winP);
            break;

        case 0xe5: /* close the scrap window */
            printf((char *) strings[4]);
            DisposeHandle((Handle) refH);
            CloseWindow(winP);
            winP = GetNextWindow(winP);
                continue;

        case 0xe8:
            printf((char *) strings[2]);
            break;

        case 0x00ec:                /* srcEdit */
            printf((char *) strings[9 + vMode]);
            ShowHide(vMode, winP);
            break;

        default:
            break;
        }
        h = (winP->portInfo.boundsRect.h1 ^ 0xffff) + 1;
        if (vMode)
            h *= 2;
        else
            h /= 2;
        MoveWindow(h, (winP->portInfo.boundsRect.v1 ^ 0xffff) + 1, winP);

        HUnlock((Handle) refH);
        winP = GetNextWindow(winP);
    }

    RefreshDesktop(0L);

    printf("\x05");
/*          |
            Turn on cursor
 */

	winP = FrontWindow();
	if (winP) {
		SelectWindow(winP);
        SetPort(winP);
    }
    GrafOn();
}

/*--------------------------------------
    closeRoot - returns -1 if canceled

    Marc Wolfgram,  9/18/91 20:26:14
*/
word closeRoot(word wfd, word action)
{
word 			i, j, retVal;
fCloseRec       closePB;
fListCtlRecHndl listCtlH;
fWindowRecHndl  refH;
fWindowRecPtr   refP;
GrafPortPtr     winP;

    retVal = 0;
    flushWorkFile(wfd);

    if (workList[wfd].wFlag & 0x4000) {
        AlertArray[0] = &workList[wfd].rootName[1];
        AlertArray[1] = (char *) strings[68 + action];
        i = AlertWindow(0x0034, (Pointer) AlertArray, 7L);
        if (!i)
            return -1;
    }
    if (i == 2) {
        flushWorkFile(wfd);
        retVal = SaveFile(wfd, (workList[wfd].wFlag & 0x2000));
    }
    if (!retVal) {

        closeTypes(wfd);			/* close all the types and editors */

        workList[wfd].wFlag = 0;
        disposeWorkData(wfd);
        CloseWindow(workList[wfd].rootWinP);

        SetupMenu(0x4040);
        sprintf(workList[wfd].editName, (char *) strings[27], (char) wfd + '1');
        SetMItemName(&workList[wfd].editName[0], (word) EditFile1Item + wfd);
        DisableMItem((word) EditFile1Item + wfd);
        CheckMItem(0, (word) EditFile1Item + wfd);
        CalcMenuSize(0,0,3);

        if (countFiles() == 0) {
            SetMItemName2(2, (long) CloseFileItem, (word) CloseFileItem);
            SetMItemName2(2, (long) OptimizeItem, (word) OptimizeItem);
            SetupMenu(0x0e80);
            CalcMenuSize(0,0,2);
            SetMenuFlag(0x0080, 4);
            HiliteMenu(0, 4);
            workTaskMask = masterTaskMask;
            for (i = (action) ? 0x48e4 : 0x48e8; i < 0x48ef; i++) { /* kill all the shell leftovers */
                winP = findSignature(i, 0, 0, 0L);
                if (winP) {
                    DisposeHandle((Handle) GetWRefCon(winP));
                    CloseWindow(winP);
                }
            }
        }
        else if (workIndex == wfd) {
        	for (i = 0; i < 4; i++) {
                if (workList[i].wFlag & 0x1000) {
        			SetMItemName(&workList[i].fileName[0], (word) CloseFileItem);
        			SetMItemName(&workList[i].packName[0], (word) OptimizeItem);
        			SetupMenu(0x4200);
			        CalcMenuSize(0,0,2);
        			CheckMItem(-1, (word) EditFile1Item + i);
        			for (j = 0; j < 4; j++)
            			if (j != i)
                			CheckMItem(0, (word) EditFile1Item + i);
            		workTaskMask = masterTaskMask;
					workIndex = i;
		            break;
		     	}
			}
		}
    }
    return retVal;
}

/*--------------------------------------
	closeTypes (extracted from closeRoot)

	Marc Wolfgram,  1/ 5/92 11:16:06
*/
void closeTypes(word wfd)
{
fCloseRec       closePB;
fListCtlRecHndl listCtlH;
fWindowRecHndl  refH;
fWindowRecPtr   refP;
GrafPortPtr     winP;

	closeREM(wfd, 0);				/* close all the editors */

    winP = GetFirstWindow();        /* close all the types */
    while(winP) {
    	if (!GetSysWFlag(winP)) {
    		refH = (fWindowRecHndl) GetWRefCon(winP);
            if (!refH) {
                winP = GetNextWindow(winP);
                continue;
            }
        	refP = (fWindowRecPtr) deref((Handle) refH);
        	if ((refP->Signature == (REM_signature + REM_tselector + wfd)) ||
        	    (refP->Signature == (REM_signature + REM_dselector + wfd))) {
        		listCtlH = (fListCtlRecHndl) GetCtlHandleFromID(winP, 2L);
        		if ((**listCtlH).ctlListRef) {
        			DisposeHandle((Handle) (**listCtlH).ctlListRef);
        			(**listCtlH).ctlListRef = 0L;
    			}
                if (refP->resPrivate)
                    DisposeHandle(refP->resPrivate);
                DisposeHandle((Handle) refH);
                CloseWindow(winP);
            }
      	}
        winP = GetNextWindow(winP);
    }
}

/*--------------------------------------
	closeREM (extracted from closeRoot)

	Marc Wolfgram,  1/ 5/92 11:16:06
*/
void closeREM(word wfd, word resType)
{
fCloseRec       closePB;
fWindowRecHndl  refH;
fWindowRecPtr   refP;
GrafPortPtr     winP;

    winP = GetFirstWindow();        /* close all the REM's */
    while(winP) {
    	if (!GetSysWFlag(winP)) {
            refH = (fWindowRecHndl) GetWRefCon(winP);
            if (!refH) {
                winP = GetNextWindow(winP);
                continue;
            }
            refP = (fWindowRecPtr) deref((Handle) refH);
            if (refP->Signature < (REM_signature + REM_fileroot) && (refP->Signature & 0x0003) == wfd &&
               		(!resType || (resType == refP->resType))) {
                closePB.resType = refP->resType;
                closePB.resID = refP->resID;
                closePB.windowPtr = (Pointer) winP;
                switch (refP->Signature & 0x0070) {
                case 0x0010:
                	closePB.fFlag = 0x0400;
                    break;
                case 0x0040:
                    closePB.fFlag = 0x1000;
                    break;
                case 0x0060:
                    closePB.fFlag = 0x0800;
                    break;
                default:
                    closePB.fFlag = 0;
                    break;
                }
                callREM(_CLOSE, (Pointer) &closePB);
                DisposeHandle(refP->resPrivate);
            	DisposeHandle((Handle) refH);
            }
        }
        winP = GetNextWindow(winP);
    }
}

/*--------------------------------------
	closeDucks (the last 1.0 bugfix)

    Marc Wolfgram,  7/17/92 21:38:20
*/
void closeDucks(void)
{
fWindowRecHndl  refH;
fWindowRecPtr   refP;
GrafPortPtr     winP;

    winP = GetFirstWindow();        /* close all the types */
    while(winP) {
    	if (!GetSysWFlag(winP)) {
    		refH = (fWindowRecHndl) GetWRefCon(winP);
            if (!refH) {
                winP = GetNextWindow(winP);
                continue;
            }
        	refP = (fWindowRecPtr) deref((Handle) refH);
            switch (refP->Signature) {
            case 0x48e4: /* help */
                refH = (fWindowRecHndl) GetWRefCon(winP);
                if (refP->resPrivate)
                    DisposeHandle(refP->resPrivate);
                DisposeHandle((Handle) refH);
                CloseWindow(winP);
                helpWin1 = 0L;
                break;

            case 0x48ef: /* help debugger */
                helpWin2 = 0L;

            case 0x48e5: /* clipboard */
	        case 0x48e8: /* namer */
                DisposeHandle((Handle) refH);
                CloseWindow(winP);
                break;

            default:
                if (refH)
                    DisposeHandle((Handle) refH);
                CloseWindow(winP);
                break;
            }
      	}
        winP = GetNextWindow(winP);
    }
}

/*--------------------------------------
    openEditor - split out of control handler for fSelector

    Marc Wolfgram, 10/22/91 19:09:16
*/
word openEditor(word resType, long resID, word mode)
{
word            i, retVal;
GrafPortPtr     found;

    found = findSignature(fEventMagic[mode+3] + workIndex, 1, resType, resID);
    if (found)
        SelectWindow(found);
    else {
        found = findSignature(fEventMagic[mode+4] + workIndex, 0, resType, resID)
                     + findSignature(fEventMagic[mode+5] + workIndex, 0, resType, resID);
        if (!found) {
            fOpenPB.resType = resType;
            fOpenPB.resID = resID;
            fOpenPB.fFlag = fEventMagic[mode];
            fOpenPB.Data = 0L;
            fOpenPB.wColorPtr = (Pointer) WColors[workIndex + c320];
            retVal = callREM(_OPEN, (Pointer) &fOpenPB);
        }
        else  {
            fGetWTitlePB.pCount = 3;
            fGetWTitlePB.resType = resType;
            fGetWTitlePB.resID = resID;
            fGetWTitlePB.resName = titleBuf;
            remGetWindowTitle(&fGetWTitlePB);
            titleBuf[titleBuf[0]] = 0x00;
            AlertArray[0] = &titleBuf[2];
            if (AlertWindow(0x0034, (Pointer) AlertArray, 6L) == 1)
                SelectWindow(found);
        }
    }
    return retVal;
}

/*--------------------------------------
    Printer - split out of control handler for fSelector

    Marc Wolfgram, 10/22/91 19:09:16
*/
word Printer(word page)
{
    fPrintPB.resType = CurWindow.resType;
    fPrintPB.resID = CurWindow.resID;
    fPrintPB.fFlag = CurMurphy;
    fPrintPB.windowPtr = (Pointer) FrontWindow();
    if (page)
	    fPrintPB.fFlag |= 0x2000;
  	if (wClass == REM_nselector) {
     	fPrintPB.fFlag |= 0x0400;   /* set selector bit */
        fPrintPB.fFlag &= 0xff7f;   /* clear menu bit */
	}
    else
    	fPrintPB.fFlag &= 0xfb7f;   /* clear selector and menu bits */

    return callREM(_PRINT, (Pointer) &fPrintPB);

}
